-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.active = true
    end
    
    self.artifact:LinkToTarget("trapRock")
    self.artifact:LinkToTarget("artifactGoal")
    self.artifact:LinkToTarget("activateHandler")
    self.artifact:LinkToTarget("winCondActive")
  end
  
  if self.active then
    p0units = self.p0:UnitsInRadiusNumberByKey(self:GetPosition(), 250, 'hero')
    
    if p0units >= 1 then
			self.artifact:TriggerAllTargets()
      self.active = false
      self:Remove()
    end    
  end  
end

function OnBeforeDeath(self)  
  self.artifact:TriggerAllTargets()
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("artifact")
end
